using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        long[] x = new long[n];
        long[] y = new long[n];

        for (int i = 0; i < n; i++)
        {
            string[] tokens = Console.ReadLine().Split();
            x[i] = long.Parse(tokens[0]);
            y[i] = long.Parse(tokens[1]);
        }

        Dictionary<long, long> count1 = new Dictionary<long, long>();
        Dictionary<long, long> count2 = new Dictionary<long, long>();

        for (int i = 0; i < n; i++)
        {
            long k1 = x[i] + y[i];
            long k2 = x[i] - y[i];

            if (!count1.ContainsKey(k1))
            {
                count1[k1] = 0;
            }
            count1[k1]++;

            if (!count2.ContainsKey(k2))
            {
                count2[k2] = 0;
            }
            count2[k2]++;
        }

        long greetings = 0;

        foreach (KeyValuePair<long, long> kv in count1)
        {
            long c = kv.Value;
            greetings += c * (c - 1) / 2;
        }

        foreach (KeyValuePair<long, long> kv in count2)
        {
            long c = kv.Value;
            greetings += c * (c - 1) / 2;
        }

        Console.WriteLine(greetings);
    }
}